import { Fragment, jsx, jsxs } from "react/jsx-runtime";
import {
  createShapeId,
  debugFlags,
  featureFlags,
  hardResetEditor,
  track,
  uniqueId,
  useEditor
} from "@tldraw/editor";
import React from "react";
import { useDialogs } from "../../context/dialogs.mjs";
import { useToasts } from "../../context/toasts.mjs";
import { untranslated } from "../../hooks/useTranslation/useTranslation.mjs";
import { TldrawUiButton } from "../primitives/Button/TldrawUiButton.mjs";
import { TldrawUiButtonCheck } from "../primitives/Button/TldrawUiButtonCheck.mjs";
import { TldrawUiButtonLabel } from "../primitives/Button/TldrawUiButtonLabel.mjs";
import {
  TldrawUiDialogBody,
  TldrawUiDialogCloseButton,
  TldrawUiDialogFooter,
  TldrawUiDialogHeader,
  TldrawUiDialogTitle
} from "../primitives/TldrawUiDialog.mjs";
import { TldrawUiMenuCheckboxItem } from "../primitives/menus/TldrawUiMenuCheckboxItem.mjs";
import { TldrawUiMenuGroup } from "../primitives/menus/TldrawUiMenuGroup.mjs";
import { TldrawUiMenuItem } from "../primitives/menus/TldrawUiMenuItem.mjs";
import { TldrawUiMenuSubmenu } from "../primitives/menus/TldrawUiMenuSubmenu.mjs";
function DefaultDebugMenuContent() {
  const editor = useEditor();
  const { addToast } = useToasts();
  const { addDialog } = useDialogs();
  const [error, setError] = React.useState(false);
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsxs(TldrawUiMenuGroup, { id: "items", children: [
      /* @__PURE__ */ jsx(
        TldrawUiMenuItem,
        {
          id: "add-toast",
          onSelect: () => {
            addToast({
              id: uniqueId(),
              title: "Something good happened",
              description: "Hey, attend to this thing over here. It might be important!",
              keepOpen: true,
              severity: "success"
              // icon?: string
              // title?: string
              // description?: string
              // actions?: TLUiToastAction[]
            });
            addToast({
              id: uniqueId(),
              title: "Something happened",
              description: "Hey, attend to this thing over here. It might be important!",
              keepOpen: true,
              severity: "info",
              actions: [
                {
                  label: "Primary",
                  type: "primary",
                  onClick: () => {
                  }
                },
                {
                  label: "Normal",
                  type: "normal",
                  onClick: () => {
                  }
                },
                {
                  label: "Danger",
                  type: "danger",
                  onClick: () => {
                  }
                }
              ]
              // icon?: string
              // title?: string
              // description?: string
              // actions?: TLUiToastAction[]
            });
            addToast({
              id: uniqueId(),
              title: "Something maybe bad happened",
              description: "Hey, attend to this thing over here. It might be important!",
              keepOpen: true,
              severity: "warning",
              actions: [
                {
                  label: "Primary",
                  type: "primary",
                  onClick: () => {
                  }
                },
                {
                  label: "Normal",
                  type: "normal",
                  onClick: () => {
                  }
                },
                {
                  label: "Danger",
                  type: "danger",
                  onClick: () => {
                  }
                }
              ]
            });
            addToast({
              id: uniqueId(),
              title: "Something bad happened",
              severity: "error",
              keepOpen: true
            });
          },
          label: untranslated("Show toast")
        }
      ),
      /* @__PURE__ */ jsx(
        TldrawUiMenuItem,
        {
          id: "show-dialog",
          label: "Show dialog",
          onSelect: () => {
            addDialog({
              component: ({ onClose }) => /* @__PURE__ */ jsx(
                ExampleDialog,
                {
                  displayDontShowAgain: true,
                  onCancel: () => onClose(),
                  onContinue: () => onClose()
                }
              ),
              onClose: () => {
              }
            });
          }
        }
      ),
      /* @__PURE__ */ jsx(
        TldrawUiMenuItem,
        {
          id: "create-shapes",
          label: "Create 100 shapes",
          onSelect: () => createNShapes(editor, 100)
        }
      ),
      /* @__PURE__ */ jsx(
        TldrawUiMenuItem,
        {
          id: "count-nodes",
          label: "Count shapes / nodes",
          onSelect: () => {
            const selectedShapes = editor.getSelectedShapes();
            const shapes = selectedShapes.length === 0 ? editor.getRenderingShapes() : selectedShapes;
            window.alert(
              `Shapes ${shapes.length}, DOM nodes:${document.querySelector(".tl-shapes").querySelectorAll("*")?.length}`
            );
          }
        }
      ),
      (() => {
        if (error) throw Error("oh no!");
        return null;
      })(),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { id: "throw-error", onSelect: () => setError(true), label: "Throw error" }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { id: "hard-reset", onSelect: hardResetEditor, label: "Hard reset" })
    ] }),
    /* @__PURE__ */ jsxs(TldrawUiMenuGroup, { id: "flags", children: [
      /* @__PURE__ */ jsx(DebugFlags, {}),
      /* @__PURE__ */ jsx(FeatureFlags, {})
    ] })
  ] });
}
function DebugFlags() {
  const items = Object.values(debugFlags);
  if (!items.length) return null;
  return /* @__PURE__ */ jsx(TldrawUiMenuSubmenu, { id: "debug flags", label: "Debug Flags", children: /* @__PURE__ */ jsx(TldrawUiMenuGroup, { id: "debug flags", children: items.map((flag) => /* @__PURE__ */ jsx(DebugFlagToggle, { flag }, flag.name)) }) });
}
function FeatureFlags() {
  const items = Object.values(featureFlags);
  if (!items.length) return null;
  return /* @__PURE__ */ jsx(TldrawUiMenuSubmenu, { id: "feature flags", label: "Feature Flags", children: /* @__PURE__ */ jsx(TldrawUiMenuGroup, { id: "feature flags", children: items.map((flag) => /* @__PURE__ */ jsx(DebugFlagToggle, { flag }, flag.name)) }) });
}
function ExampleDialog({
  title = "title",
  body = "hello hello hello",
  cancel = "Cancel",
  confirm = "Continue",
  displayDontShowAgain = false,
  onCancel,
  onContinue
}) {
  const [dontShowAgain, setDontShowAgain] = React.useState(false);
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsxs(TldrawUiDialogHeader, { children: [
      /* @__PURE__ */ jsx(TldrawUiDialogTitle, { children: title }),
      /* @__PURE__ */ jsx(TldrawUiDialogCloseButton, {})
    ] }),
    /* @__PURE__ */ jsx(TldrawUiDialogBody, { style: { maxWidth: 350 }, children: body }),
    /* @__PURE__ */ jsxs(TldrawUiDialogFooter, { className: "tlui-dialog__footer__actions", children: [
      displayDontShowAgain && /* @__PURE__ */ jsxs(
        TldrawUiButton,
        {
          type: "normal",
          onClick: () => setDontShowAgain(!dontShowAgain),
          style: { marginRight: "auto" },
          children: [
            /* @__PURE__ */ jsx(TldrawUiButtonCheck, { checked: dontShowAgain }),
            /* @__PURE__ */ jsx(TldrawUiButtonLabel, { children: "Don\u2019t show again" })
          ]
        }
      ),
      /* @__PURE__ */ jsx(TldrawUiButton, { type: "normal", onClick: onCancel, children: /* @__PURE__ */ jsx(TldrawUiButtonLabel, { children: cancel }) }),
      /* @__PURE__ */ jsx(TldrawUiButton, { type: "primary", onClick: async () => onContinue(), children: /* @__PURE__ */ jsx(TldrawUiButtonLabel, { children: confirm }) })
    ] })
  ] });
}
const DebugFlagToggle = track(function DebugFlagToggle2({
  flag,
  onChange
}) {
  const value = flag.get();
  return (
    /* @__PURE__ */ jsx(
      TldrawUiMenuCheckboxItem,
      {
        id: flag.name,
        title: flag.name,
        label: flag.name.replace(/([a-z0-9])([A-Z])/g, (m) => `${m[0]} ${m[1].toLowerCase()}`).replace(/^[a-z]/, (m) => m.toUpperCase()),
        checked: value,
        onSelect: () => {
          flag.set(!value);
          onChange?.(!value);
        }
      }
    )
  );
});
let t = 0;
function createNShapes(editor, n) {
  const shapesToCreate = Array(n);
  const cols = Math.floor(Math.sqrt(n));
  for (let i = 0; i < n; i++) {
    t++;
    shapesToCreate[i] = {
      id: createShapeId("box" + t),
      type: "geo",
      x: i % cols * 132,
      y: Math.floor(i / cols) * 132
    };
  }
  editor.run(() => {
    editor.createShapes(shapesToCreate).setSelectedShapes(shapesToCreate.map((s) => s.id));
  });
}
export {
  DebugFlags,
  DefaultDebugMenuContent,
  ExampleDialog,
  FeatureFlags
};
//# sourceMappingURL=DefaultDebugMenuContent.mjs.map
